﻿/*	VERSION:	1.4

USAGE:
	#include "functions/paletteCycle.as"
	var settings = {target:my_mc, palette:"fire.png", speed:1, direction:"left"};
	var my_fx = makePaletteCycle( {parent:this, name:"fx_mc", depth:nextDepth(this)},  settings );
	my_fx.palette = "water.png";

SETTINGS:
	clipSettings		Settings for the container movieClip that'll be created
		parent					Where to create this movieClip
		depth						Which depth layer this movieClip should occupy
		name						("cycler")  What instance-name this movieClip should have.
	settings				Settings for the effect itself
		target					Reference		A MovieClip / BitmapData whose appearance will be copied by this effect
		palette					String / BitmapData			A Filename for an image containing the palette to use  OR  A bitmapData image containing a palette
		speed						Number			(1)		A Multiplier controlling how fast this effect animates
		direction				String			("right") / "left"		A flag indicating which way to cycle the palette
*/

#include "nextDepth.as"
#include "nextName.as"
#include "loadImage.as"
makePaletteCycle = function( clipSettings, effectSettings )
{
	var widthLimit = 640;
	var heightLimit = 480;
	// resolve the settings for the new movieClip container
	var parent = clipSettings.parent || this;
	var newDepth = clipSettings.depth || nextDepth(parent)
	var newName = clipSettings.name || nextName("cycler", parent);
	var _this = parent.createEmptyMovieClip(newName, newDepth);
	
	// initialize settings for the effect's interface
	var target = effectSettings.target || null;
	var palette = effectSettings.palette || "";
	var speed = (effectSettings.speed != undefined) ? effectSettings.speed : 1;
	var direction = (effectSettings.direction=="right"||effectSettings.direction=="left") ? effectSettings.direction : "right";
	
	// initialize internal params
	var animSpeed = Number(speed);
	var image_pic = updateMapPic( target ) || new flash.display.BitmapData(1,1,true,0);
	var animDir = shiftRight;		// directly references the function to use
	
	
	
	// initialize palette arrays
	var palette_array = [0];		// start with a dingle color, that's black
	var disabled_array = [];
	for(var i=0; i<256; i++)		disabled_array[i] = 0;
	
	
	// create output
	var output_mc = _this.createEmptyMovieClip("output_mc", 0);
	delete _this.output_mc;		// prevent external access
	output_mc._name = "";			// prevent external access
	var output_pic = image_pic.clone();
	output_mc.attachBitmap( output_pic,0 );
	
	
	// animate
	_this.onEnterFrame = function(){
		// change the palette
		for(var i=0; i<(10*animSpeed); i++){
			animDir();
		}
		// redraw the image using the modified palette
		update();
	}// loop()
	
	function shiftLeft(){
		var thisColor = palette_array.pop();
		palette_array.unshift(thisColor);
	}// shiftLeft()
	function shiftRight(){
		var thisColor = palette_array.shift();
		palette_array.push(thisColor);
	}// shiftRight()
	function update(){
		var copy = new flash.geom.Rectangle(0,0, image_pic.width, image_pic.height);
		var paste = new flash.geom.Point(0,0);
		output_pic.paletteMap( image_pic, copy,paste, disabled_array,disabled_array, palette_array);
		//output_pic.paletteMap( image_pic, copy,paste, null,null,null);
	}// update()
	
	
	
	//////////////////////////////////////////////////////////////////////////////
	// take a snapshot of a specified movieClip
	function updateMapPic( newTarget )
	{
		if(newTarget){
			_this._visible = false;
			var w = newTarget._width || newTarget.width || 1;
			var h = newTarget._height || newTarget.height || 1;
			if(w > Stage.width)		w = Stage.width;
			if(h > Stage.height)	h = Stage.height;
			if(w > widthLimit)		w = widthLimit;
			if(h > heightLimit)		h = heightLimit;
			//trace("("+w+", "+h+")");
			var new_pic = new flash.display.BitmapData( w,h, true,0);
			new_pic.draw( newTarget );
			_this._visible = true;
			
			// change it into grayscale
			var gray_mat = [ .33,.33,.33,0,0,
												.33,.33,.33,0,0,
												.33,.33,.33,0,0,
												0,0,0,1,0 ];
			var gray_fx = new flash.filters.ColorMatrixFilter(gray_mat);
			var area_rect = new flash.geom.Rectangle(0,0, new_pic.width, new_pic.height);
			new_pic.applyFilter( new_pic, area_rect, null, gray_fx);
			
			return new_pic;
		}// if:  newTarget exists
		else
		{// if:  no target to copy
			return null;
		}// if:  no target to copy
	}// updateMapPic()
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////
	// target
	var init_target = target || null;
	var get_target = function(){
		return _this._target;
	}
	var set_target = function( newValue ){
		_this._target = newValue;
		
		image_pic = updateMapPic( newValue ) || new flash.display.BitmapData(1,1,true,0);
		
		output_pic.dispose();		// remove the previous image data
		output_pic = image_pic.clone();
		output_mc.attachBitmap( output_pic,0 );
		update();
	}// set()
	_this.addProperty("target", get_target, set_target);
	_this.target = init_target;
	
	
	
	// palette
	var init_palette = palette || "";
	var get_palette = function(){
		return _this._palette;
	}
	var set_palette = function( newValue ){
		_this._palette = newValue;
		var loader = loadImage(newValue, _this, "newPalette", 1, false);
		loader._name = "";		// prevent external access
		var success = function(){
			
			var loaded_mc = _this.newPalette;
			// load palette & store it in an array
			// // take a snapshot of the loaded palette image
			var palette_pic = new flash.display.BitmapData( loaded_mc._width, loaded_mc._height, false, 0 );
			palette_pic.draw( loaded_mc );
			loaded_mc.removeMovieClip();
			// // extract colors from the snapshot  &  overwrite palette_array
			var palLength = palette_pic.width;
			palette_array = new Array(palLength);
			for(var i=0; i<palLength; i++)
				palette_array[i] = palette_pic.getPixel(i,0) || 0;
				
		}// success()
		loader.onLoadInit = success;
		if(!loader)		// if:  no loader was needed
			success();
	}// set()
	_this.addProperty("palette", get_palette, set_palette);
	_this.palette = init_palette;
	
	
	
	// speed
	var init_speed = (speed!=undefined) ? speed : 0.5;
	var get_speed = function(){
		return _this._speed;
	}
	var set_speed = function( newValue ){
		_this._speed = newValue;
		animSpeed = Number(newValue);
	}// set()
	_this.addProperty("speed", get_speed, set_speed);
	_this.speed = init_speed;
	
	
	
	
	// direction
	var init_direction = direction || "right";
	var get_direction = function(){
		return _this._direction;
	}
	var set_direction = function( newValue ){
		_this._direction = newValue;
		if(newValue == "right")
			animDir = shiftRight;
		else if(newValue == "left")
			animDir = shiftLeft;
	}// set()
	_this.addProperty("direction", get_direction, set_direction);
	_this.direction = init_direction;
	
	
	return _this;
}// makePaletteCycle()